const path = require('path');
const defaults = require('@wordpress/scripts/config/webpack.config');

const commons = {
    ...defaults,
    module: {
        ...defaults.module,
        rules: [
            ...defaults.module.rules,
            {
                test: /\.tsx?$/,
                use: [
                    {
                        loader: 'ts-loader',
                        options: {
                            transpileOnly: true,
                            configFile: 'tsconfig.json',
                        },
                    },
                ],
            },
        ],
    },
    resolve: {
        extensions: ['.ts', '.tsx', ...(defaults.resolve ? defaults.resolve.extensions || ['.js', '.jsx'] : [])],
    },
};

const config1 = {
    ...commons,
    entry: {
        scripts: path.resolve(process.cwd(), 'assets/src', 'scripts.ts'),
    },
    output: {
        filename: '[name].js',
        path: path.resolve(process.cwd(), 'assets/public'),
    },
};

const config2 = {
    ...commons,
    entry: {
        scripts: path.resolve(process.cwd(), 'assets/src-blocks', 'scripts.ts'),
    },
    output: {
        filename: '[name].js',
        path: path.resolve(process.cwd(), 'assets/public/blocks'),
    },
};

module.exports = [config1, config2];
