<?php

namespace Soft_Tehnica\Freya_Sync_Service\Data;

use Soft_Tehnica\Freya_Sync_Service\Services\SessionService;

if (!class_exists('FsPickupMethod')) {
    class FsPickupMethod extends \WC_Shipping_Method
    {
        public function __construct(int $instance_id = 0)
        {
            $this->id = 'fs_pickup_method';
            $this->method_title = 'Freya Sync - Ridicare personală';
            $this->method_description = 'Aceasta este metoda de plată adaugată de Freya Sync pentru Ridicare personală';
            $this->supports = array('shipping-zones');
            $this->plugin_id = 'freya_sync_service_';

            $this->title = 'Ridicare personală';

            parent::__construct($instance_id);
        }

        public function calculate_shipping($package = array()): void
        {
            if (!SessionService::get()->isPickup()) {
                return;
            }

            $this->add_rate([
                'id' => $this->id,
                'label' => $this->title,
                'cost' => 0,
                'taxes' => false,
                'calc_tax' => 'per_order'
            ]);
        }
    }
}