<?php

namespace Soft_Tehnica\Freya_Sync_Service\Services;

class PluginSettings
{
    private static PluginSettings $instance;
    private static bool $initialized = false;

    private ?string $companyUid = null;
    private ?string $defaultLocationUid = null;
    private array $pagesThatRequestAddress = [];
    private bool $enableMultiSubdomain = false;
    private bool $hasLandingPage = false;
    private bool $polygonsDisabled = false;
    private bool $showAllProductsOnNoLocation = false;
    private bool $_hideModalDismiss = false;
    private ?string $countyRestriction = null;
    private ?string $noAddressFoundMessage = null;

    protected function __construct()
    {
    }

    public function initializeSettings(): void
    {
        if (static::$initialized) {
            return;
        }
        $options = get_option('fs_option_settings', array());

        $this->companyUid = (isset($options['fsCompanyUid'])) ? $options['fsCompanyUid'] : null;
        $this->defaultLocationUid = (isset($options['fsDefaultLocationUid'])) ? $options['fsDefaultLocationUid'] : null;
        $this->pagesThatRequestAddress = (isset($options['fsAddressRequestOnPages'])) ? $options['fsAddressRequestOnPages'] : [];
        $this->enableMultiSubdomain = isset($options['fsEnableMultiSubdomain']) && $options['fsEnableMultiSubdomain'] === 1;
        $this->hasLandingPage = isset($options['fsIsRunningOnLandingPageInstance']) && $options['fsIsRunningOnLandingPageInstance'] === 1;
        $this->countyRestriction = (isset($options['fsCountyRestriction'])) ? $options['fsCountyRestriction'] : null;
        $this->noAddressFoundMessage = (isset($options['fsNoAddressFoundMessage'])) ? $options['fsNoAddressFoundMessage'] : null;
        $this->polygonsDisabled = isset($options['fsNoPolygons']) && $options['fsNoPolygons'] === 1;
        $this->showAllProductsOnNoLocation = $options['fsShowAllProductsNoLocation'] ?? 0 === 1;
        $this->_hideModalDismiss = $options['fsHideModalDismiss'] ?? 0 === 1;
        static::$initialized = true;
    }

    protected function __clone()
    {
    }

    public static function get(): PluginSettings
    {
        if (!isset(static::$instance)) {
            static::$instance = new PluginSettings();
        }

        return static::$instance;
    }

    public function getCompanyUid(): ?string
    {
        return $this->companyUid;
    }

    public function getDefaultLocationUid(): ?string
    {
        return $this->defaultLocationUid;
    }

    public function getPagesThatRequestAddress(): array
    {
        return $this->pagesThatRequestAddress;
    }

    public function isEnableMultiSubdomain(): bool
    {
        return $this->enableMultiSubdomain;
    }

    public function isHasLandingPage(): bool
    {
        return $this->hasLandingPage;
    }

    public function isPolygonsDisabled(): bool
    {
        return $this->polygonsDisabled;
    }

    public function getShowAllProductsOnNoLocation(): bool
    {
        return $this->showAllProductsOnNoLocation;
    }

    public function getCountyRestriction(): ?string
    {
        return $this->countyRestriction;
    }

    public function getNoAddressFoundMessage(): ?string
    {
        return $this->noAddressFoundMessage;
    }

    public function hideModalDismiss(): bool
    {
        return $this->_hideModalDismiss;
    }
}