/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./assets/src/autocomplete-client.ts":
/*!*******************************************!*\
  !*** ./assets/src/autocomplete-client.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AutocompleteClient)
/* harmony export */ });
/* harmony import */ var _freya_sync_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./freya-sync-service */ "./assets/src/freya-sync-service.ts");
/* harmony import */ var devbridge_autocomplete__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! devbridge-autocomplete */ "./node_modules/devbridge-autocomplete/dist/jquery.autocomplete.js");
/* harmony import */ var devbridge_autocomplete__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(devbridge_autocomplete__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lib_jquery__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./lib/jquery */ "./assets/src/lib/jquery.ts");



class AutocompleteClient {
  constructor() {
    this.sessionUid = undefined;
    const data = _freya_sync_service__WEBPACK_IMPORTED_MODULE_0__["default"].sharedInstance.data;
    if (!data.api_url.endsWith('/')) {
      data.api_url += '/';
    }
    this.serviceUrl = data.api_url;
  }
  get placeDetailsUrl() {
    return `${this.serviceUrl}wp/getGooglePlaceDetails`;
  }
  autocomplete(callbacks) {
    const settings = _freya_sync_service__WEBPACK_IMPORTED_MODULE_0__["default"].sharedInstance.settings;
    // Nu stergeti asta, PHPStorm nu e de acord
    // @ts-ignore
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_2__["default"])('#streetName').autocomplete({
      serviceUrl: () => {
        var _a;
        return `${this.serviceUrl}wp/geodecoding?sessionUid=${(_a = this.sessionUid) !== null && _a !== void 0 ? _a : ''}`;
      },
      minChars: 3,
      paramName: 'q',
      params: {
        countyRestriction: settings.fsCountyRestriction,
        companyUid: settings.fsCompanyUid
      },
      noCache: true,
      preventBadQueries: false,
      zIndex: 99999,
      showNoSuggestionNotice: true,
      noSuggestionNotice: 'Nu am gasit rezultate...',
      deferRequestBy: 300,
      transformResult: response => {
        const object = JSON.parse(response);
        if (object.payload.session_uid) {
          this.sessionUid = object.payload.session_uid;
        }
        return {
          suggestions: _lib_jquery__WEBPACK_IMPORTED_MODULE_2__["default"].map(object.payload.suggestions, function (dataItem) {
            return {
              value: dataItem.displayName,
              data: dataItem
            };
          })
        };
      },
      onSelect: suggestion => {
        const data = suggestion.data;
        if (data.type === 'google') {
          if (this.lastResult && this.lastResult.id === data.id) {
            callbacks.onSelect(this.lastResult);
            return;
          }
          if (callbacks.onGoogleStartRequest) {
            callbacks.onGoogleStartRequest();
          }
          try {
            this.getGooglePlaceDetails(data.id).then(details => {
              this.lastResult = details;
              callbacks.onSelect(details);
            });
            return;
          } catch (e) {
            if (callbacks.onSelectError) {
              callbacks.onSelectError(e);
            }
            return;
          }
        }
        if (data.type === 'nominatim') {
          this.lastResult = data;
          callbacks.onSelect(data);
        }
      },
      onSearchStart: function () {
        if (callbacks.onSearchStart) {
          callbacks.onSearchStart();
        }
      },
      onSearchComplete: function () {
        if (callbacks.onSearchComplete) {
          callbacks.onSearchComplete();
        }
      },
      onSearchError: function () {
        if (callbacks.onSearchError) {
          callbacks.onSearchError();
        }
      }
    });
  }
  async getGooglePlaceDetails(placeId) {
    if (!this.sessionUid) {
      throw new Error('Something went wrong');
    }
    const settings = _freya_sync_service__WEBPACK_IMPORTED_MODULE_0__["default"].sharedInstance.settings;
    const data = {
      place_id: placeId,
      companyUid: settings.fsCompanyUid,
      sessionUid: this.sessionUid
    };
    return new Promise(async (resolve, reject) => {
      const params = new URLSearchParams(data);
      const r = await fetch(`${this.placeDetailsUrl}?${params.toString()}`, {
        method: 'GET',
        headers: {
          Accept: 'application/json'
        }
      });
      if (!r.ok) {
        if (r.headers.has('content-type') && r.headers.get('content-type') === 'application/json') {
          const response = await r.json();
          reject(response);
        }
      }
      const response = await r.json();
      this.sessionUid = undefined;
      resolve(response.payload);
    });
  }
}

/***/ }),

/***/ "./assets/src/checkout.ts":
/*!********************************!*\
  !*** ./assets/src/checkout.ts ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   setupCheckout: () => (/* binding */ setupCheckout)
/* harmony export */ });
/* harmony import */ var _lib_jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lib/jquery */ "./assets/src/lib/jquery.ts");
/* harmony import */ var _freya_sync_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./freya-sync-service */ "./assets/src/freya-sync-service.ts");


const setupCheckout = () => {
  var _a, _b;
  if (_freya_sync_service__WEBPACK_IMPORTED_MODULE_1__["default"].sharedInstance.settings.fsNoPolygons || _freya_sync_service__WEBPACK_IMPORTED_MODULE_1__["default"].sharedInstance.data.pickup) {
    return;
  }
  (_a = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('#shipping-address_1')) === null || _a === void 0 ? void 0 : _a.prop('readonly', true);
  (_b = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('#billing-address_1')) === null || _b === void 0 ? void 0 : _b.prop('readonly', true);
};

/***/ }),

/***/ "./assets/src/freya-sync-service.ts":
/*!******************************************!*\
  !*** ./assets/src/freya-sync-service.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FreyaSyncService)
/* harmony export */ });
/* harmony import */ var _modal_address__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modal-address */ "./assets/src/modal-address.ts");
/* harmony import */ var _lib_jquery__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lib/jquery */ "./assets/src/lib/jquery.ts");
/* harmony import */ var _order_resync__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./order-resync */ "./assets/src/order-resync.ts");
/* harmony import */ var _topping_display__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./topping-display */ "./assets/src/topping-display.ts");
/* harmony import */ var _settings_validator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./settings-validator */ "./assets/src/settings-validator.ts");
/* harmony import */ var _checkout__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./checkout */ "./assets/src/checkout.ts");






class FreyaSyncService {
  constructor(phpData, settings) {
    this.phpData = phpData;
    this.pluginSettings = settings;
  }
  /**
   * Bootstrap function, only used once at the beginning of plugin runtime
   * @param data
   */
  static async bootstrap(data) {
    if (FreyaSyncService.instance) {
      return;
    }
    const settings = await fetchSettings(data.ajax_url, data.nonce);
    FreyaSyncService.instance = new FreyaSyncService(data, settings);
    FreyaSyncService.instance.bootstrapComponents();
  }
  bootstrapComponents() {
    _modal_address__WEBPACK_IMPORTED_MODULE_0__["default"].bootstrap();
    _order_resync__WEBPACK_IMPORTED_MODULE_2__["default"].bootstrap();
    _topping_display__WEBPACK_IMPORTED_MODULE_3__["default"].bootstrap();
    _settings_validator__WEBPACK_IMPORTED_MODULE_4__["default"].bootstrap();
    (0,_checkout__WEBPACK_IMPORTED_MODULE_5__.setupCheckout)();
  }
  static get sharedInstance() {
    if (!FreyaSyncService.instance) {
      throw new Error('No instance');
    }
    return FreyaSyncService.instance;
  }
  get settings() {
    return this.pluginSettings;
  }
  get data() {
    return this.phpData;
  }
}
async function fetchSettings(ajax_url, nonce) {
  return new Promise((resolve, reject) => {
    _lib_jquery__WEBPACK_IMPORTED_MODULE_1__["default"].ajax({
      type: 'POST',
      url: ajax_url,
      dataType: 'json',
      data: {
        action: 'freya_sync_service_get_settings',
        nonce: nonce
      },
      success: data => {
        const settings = {
          fsCompanyUid: data.data.fsCompanyUid,
          fsDefaultLocationUid: data.data.fsDefaultLocationUid,
          fsCountyRestriction: data.data.fsCountyRestriction,
          fsServiceUrl: data.data.fsServiceUrl,
          fsNoAddressFoundMessage: data.data.fsNoAddressFoundMessage,
          fsAddressRequestOnPages: data.data.fsAddressRequestOnPages,
          fsIsRunningOnLandingPageInstance: Number(data.data.fsIsRunningOnLandingPageInstance) === 1,
          fsEnableMultiSubdomain: Number(data.data.fsEnableMultiSubdomain) === 1,
          fsNoPolygons: Number(data.data.fsNoPolygons) === 1
        };
        resolve(settings);
      },
      error: (xhr, ajaxOptions, thrownError) => {
        reject();
      }
    });
  });
}

/***/ }),

/***/ "./assets/src/lib/jquery.ts":
/*!**********************************!*\
  !*** ./assets/src/lib/jquery.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const $j = jQuery.noConflict();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ($j);

/***/ }),

/***/ "./assets/src/modal-address.ts":
/*!*************************************!*\
  !*** ./assets/src/modal-address.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModalAddress)
/* harmony export */ });
/* harmony import */ var devbridge_autocomplete__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! devbridge-autocomplete */ "./node_modules/devbridge-autocomplete/dist/jquery.autocomplete.js");
/* harmony import */ var devbridge_autocomplete__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(devbridge_autocomplete__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _autocomplete_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./autocomplete-client */ "./assets/src/autocomplete-client.ts");
/* harmony import */ var _freya_sync_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./freya-sync-service */ "./assets/src/freya-sync-service.ts");
/* harmony import */ var _lib_jquery__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./lib/jquery */ "./assets/src/lib/jquery.ts");




class ModalAddress {
  constructor() {
    this.suggestion = undefined;
    this.autocompleteClient = new _autocomplete_client__WEBPACK_IMPORTED_MODULE_1__["default"]();
    this.setupJquery();
  }
  static bootstrap() {
    if (this.instance) {
      return;
    }
    this.instance = new ModalAddress();
  }
  static get sharedInstance() {
    if (!this.instance) {
      throw new Error('No ModalAddress instance');
    }
    return this.instance;
  }
  blockInterface() {
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.fsUserAddressForm > input').attr('readonly', 'true');
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.fss-modal__buttons > button').prop('disabled', true);
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.cancelLoading').css('display', 'inline-block');
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.address-modal-save').prop('disabled', true);
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.address-modal-close').prop('disabled', true);
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.address-modal-save > i').css('display', 'inline-block');
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.streetNoLoading').css('display', 'inline-block');
  }
  unBlockInterface() {
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.fsUserAddressForm > input').attr('readonly', 'false');
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.fss-modal__buttons > button').prop('disabled', false);
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.cancelLoading').css('display', 'none');
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.address-modal-save').prop('disabled', false);
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.address-modal-close').prop('disabled', false);
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.address-modal-save > i').css('display', 'none');
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.streetNoLoading').css('display', 'hide');
  }
  onModalDismissed() {
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#fss-modal').removeClass('fss-modal-visible');
    _lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"].ajax({
      type: 'POST',
      url: _freya_sync_service__WEBPACK_IMPORTED_MODULE_2__["default"].sharedInstance.data.ajax_url,
      dataType: 'json',
      data: {
        action: 'cart_service_service_modal_dismissed'
      },
      success: () => {}
    });
  }
  hasPickup() {
    if (!(0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])("input[type='radio'][name='deliveryType']").length) {
      // No radio button exists
      return (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('select#location').length !== 0;
    }
    return (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])("input[type='radio'][name='deliveryType']:checked").val() === '2';
  }
  validateModal() {
    const errorMessages = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#localizationModalErrorMessages');
    const successMessages = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#localizationModalSuccessMessages');
    const streetNo = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#streetNo');
    const loadingElem = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.mLoading');
    const pickup = this.hasPickup();
    if (pickup) {
      return true;
    }
    if (!this.suggestion || typeof this.suggestion !== 'object') {
      loadingElem.css('display', 'none');
      errorMessages.show();
      successMessages.hide();
      errorMessages.html('Vă rugăm să introduceți strada și numărul, apoi selectați o adresă din listă.');
      this.unBlockInterface();
      return false;
    }
    return true;
  }
  async onModalSave() {
    var _a, _b, _c, _d, _e, _f, _g;
    this.blockInterface();
    const errorMessages = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#localizationModalErrorMessages');
    const successMessages = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#localizationModalSuccessMessages');
    const streetNo = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#streetNo');
    const loadingElem = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.mLoading');
    if (!this.validateModal()) {
      return;
    }
    errorMessages.hide();
    const pickup = this.hasPickup();
    const locationData = await this.getLocationData(pickup);
    if (!locationData || !locationData.status) {
      const message = (_a = locationData === null || locationData === void 0 ? void 0 : locationData.message) !== null && _a !== void 0 ? _a : 'Ceva nu a mers bine, vă rugăm să încercați din nou.';
      loadingElem.css('display', 'none');
      errorMessages.show().text(message);
      successMessages.hide();
      this.unBlockInterface();
      return;
    }
    if (pickup) {
      const select = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#fss-modal select#location');
      let uid = undefined;
      if (select) {
        uid = String((_b = select.find(':selected').val()) !== null && _b !== void 0 ? _b : '');
      }
      const data = {
        pickup: true
      };
      if (uid) {
        data.locationUid = uid;
      }
      successMessages.show().text(`Locația care vă procesează comanda este: ${locationData.payload.name}. Vă rugăm să așteptați câteva momente.`);
      errorMessages.hide();
      this.setLocation(data, locationData.payload.url);
      return;
    }
    successMessages.show().text(`Locația care vă procesează comanda este: ${locationData.payload.name}. Vă rugăm să așteptați câteva momente.`);
    errorMessages.hide();
    const data = {
      geo: this.suggestion,
      taxes: locationData.payload.taxes,
      locationUid: locationData.payload.locationUid,
      companyUid: _freya_sync_service__WEBPACK_IMPORTED_MODULE_2__["default"].sharedInstance.settings.fsCompanyUid,
      streetNo: String((_c = streetNo.val()) !== null && _c !== void 0 ? _c : ''),
      blockNo: String((_d = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.fsUserAddressForm > #blockNo').val()) !== null && _d !== void 0 ? _d : ''),
      floor: String((_e = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.fsUserAddressForm > #blockNo').val()) !== null && _e !== void 0 ? _e : ''),
      entranceNo: String((_f = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.fsUserAddressForm > #blockNo').val()) !== null && _f !== void 0 ? _f : ''),
      apartmentNo: String((_g = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.fsUserAddressForm > #blockNo').val()) !== null && _g !== void 0 ? _g : '')
    };
    this.setLocation(data, locationData.payload.url);
  }
  async getLocationData(pickup = false) {
    var _a, _b, _c, _d, _e;
    let formData = {
      pickup,
      uid: _freya_sync_service__WEBPACK_IMPORTED_MODULE_2__["default"].sharedInstance.settings.fsCompanyUid
    };
    if (pickup) {
      const select = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#fss-modal select#location');
      let uid;
      if (select) {
        uid = String((_a = select.find(':selected').val()) !== null && _a !== void 0 ? _a : '');
      } else {
        uid = _freya_sync_service__WEBPACK_IMPORTED_MODULE_2__["default"].sharedInstance.settings.fsDefaultLocationUid;
      }
      formData.chosenLocationUid = uid;
    } else {
      formData.streetName = String((_b = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#streetName').val()) !== null && _b !== void 0 ? _b : '');
      formData.streetNo = String((_c = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#streetNo').val()) !== null && _c !== void 0 ? _c : '');
      formData.blockNo = String((_d = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#blockNo').val()) !== null && _d !== void 0 ? _d : '');
      formData.apartmentNo = String((_e = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#apartmentNo').val()) !== null && _e !== void 0 ? _e : '');
      formData.geo = this.suggestion;
    }
    try {
      const r = await fetch(this.findCloserLocationUrl, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify(formData)
      });
      if (!r.ok) {
        if (r.headers.get('content-type') === 'application/json') {
          return await r.json();
        }
        return undefined;
      }
      return await r.json();
    } catch (e) {
      return undefined;
    }
  }
  setLocation(data, url) {
    if (!_freya_sync_service__WEBPACK_IMPORTED_MODULE_2__["default"].sharedInstance.settings.fsEnableMultiSubdomain) {
      this.setLocationSingleSite(data);
      return;
    }
    const errorMessages = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#localizationModalErrorMessages');
    const successMessages = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#localizationModalSuccessMessages');
    const encoded = btoa(encodeURIComponent(JSON.stringify(data)));
    if (!url) {
      successMessages.hide();
      errorMessages.show().text('Nu am putut redirecționa browser-ul către locația aleasă. Încercați din nou.');
      this.unBlockInterface();
      return;
    }
    location.href = `${url}?redirect-payload=${encoded}`;
  }
  setLocationSingleSite(data) {
    this.blockInterface();
    _lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"].ajax({
      type: 'POST',
      url: _freya_sync_service__WEBPACK_IMPORTED_MODULE_2__["default"].sharedInstance.data.ajax_url,
      data: Object.assign({
        action: 'fss_set_location_settings',
        nonce: _freya_sync_service__WEBPACK_IMPORTED_MODULE_2__["default"].sharedInstance.data.nonce
      }, data),
      dataType: 'json',
      success: response => {
        if (!response.success) {
          let message = 'Ceva nu a mers bine, vă rugăm să încercați din nou.';
          (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#localizationModalErrorMessages').show().text(message);
          this.unBlockInterface();
          return;
        }
        (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.mLoading').hide();
        this.unBlockInterface();
        (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#fss-modal').removeClass('fss-modal-visible');
        location.reload();
      },
      error: xhr => {
        let message = 'Ceva nu a mers bine, vă rugăm să încercați din nou.';
        if (xhr.responseJSON.message) {
          message = xhr.responseJSON.message;
        }
        (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#localizationModalErrorMessages').show().text(message);
        this.unBlockInterface();
      }
    });
  }
  openModal() {
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#fss-modal').addClass('fss-modal-visible');
    if ((0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.xoo-wsch-close')[0]) {
      (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.xoo-wsch-close').trigger('click');
    }
  }
  setupStreetAutocomplete() {
    this.autocompleteClient.autocomplete({
      onSelect: suggestion => {
        this.unBlockInterface();
        (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#streetNo').val('');
        if (suggestion.streetNumber) {
          if (suggestion.streetNumber) {
            (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#streetNo').val(suggestion.streetNumber);
          }
        }
        this.suggestion = suggestion;
      },
      onSelectError: error => {
        var _a;
        this.unBlockInterface();
        (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.cancelLoading').css('display', 'none');
        (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.streetNoLoading').css('display', 'none');
        (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#localizationModalErrorMessages').show().text((_a = error.message) !== null && _a !== void 0 ? _a : 'Ceva nu a mers bine!');
      },
      onGoogleStartRequest: () => {
        this.blockInterface();
      },
      onSearchStart: () => {
        (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.streetNameLoading').css('display', 'inline');
      },
      onSearchComplete: () => {
        (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.streetNameLoading').css('display', 'none');
      },
      onSearchError: () => {
        (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.streetNameLoading').css('display', 'none');
      }
    });
  }
  setupJquery() {
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])(document).on('ready', () => {
      const deliveryForm = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#fss-modal .fss-modal__fields_group');
      const loading = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.mLoading');
      const cancelLoading = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.cancelLoading');
      const locationSelect = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('#fss-modal .location-select-container');
      loading.css('display', 'none');
      loading.css('display', 'none');
      cancelLoading.css('display', 'none');
      const checked = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])("input[type='radio'][name='deliveryType']:checked").val();
      switch (checked) {
        case '1':
          deliveryForm.removeClass('fss-hide');
          locationSelect.addClass('fss-hide');
          break;
        case '2':
          deliveryForm.addClass('fss-hide');
          locationSelect.removeClass('fss-hide');
          break;
      }
      (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])("input[type='radio'][name='deliveryType']").on('change', () => {
        const value = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])("input[type='radio'][name='deliveryType']:checked").val();
        switch (value) {
          case '1':
            deliveryForm.removeClass('fss-hide');
            locationSelect.addClass('fss-hide');
            break;
          case '2':
            deliveryForm.addClass('fss-hide');
            locationSelect.removeClass('fss-hide');
            break;
        }
      });
      (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.address-modal-close').on('click', () => {
        this.onModalDismissed();
      });
      (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.address-modal-save').on('click', async () => {
        await this.onModalSave();
      });
      (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_3__["default"])('.address-modal-open').on('click', () => {
        this.openModal();
      });
      this.setupStreetAutocomplete();
    });
  }
  get findCloserLocationUrl() {
    const data = _freya_sync_service__WEBPACK_IMPORTED_MODULE_2__["default"].sharedInstance.data;
    return data.api_url + 'wp/findCloserLocation';
  }
}

/***/ }),

/***/ "./assets/src/order-resync.ts":
/*!************************************!*\
  !*** ./assets/src/order-resync.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ OrderResync)
/* harmony export */ });
/* harmony import */ var _lib_jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lib/jquery */ "./assets/src/lib/jquery.ts");
/* harmony import */ var _freya_sync_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./freya-sync-service */ "./assets/src/freya-sync-service.ts");


class OrderResync {
  constructor() {
    this.orderId = undefined;
    this.needsResync = false;
    this.setupJquery();
  }
  static bootstrap() {
    if (this.instance) {
      return;
    }
    this.instance = new OrderResync();
  }
  static get sharedInstance() {
    if (!this.instance) {
      throw new Error('No OrderResync instance');
    }
    return this.instance;
  }
  getOrder() {
    if (!this.orderId) {
      return;
    }
    const resyncButton = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('#fsResyncOrder');
    resyncButton.prop('disabled', true);
    _lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"].ajax({
      url: _freya_sync_service__WEBPACK_IMPORTED_MODULE_1__["default"].sharedInstance.data.ajax_url,
      dataType: 'json',
      type: 'GET',
      data: {
        action: 'fss_get_order_location',
        id: this.orderId,
        nonce: _freya_sync_service__WEBPACK_IMPORTED_MODULE_1__["default"].sharedInstance.data.nonce
      },
      success: res => {
        this.locationUid = res.data.locationUid;
        this.needsResync = res.data.needsResync;
        if (this.needsResync) {
          resyncButton.prop('disabled', false);
          resyncButton.on('click', () => {
            this.resyncOrder();
          });
        }
      },
      error: jqXHR => {
        console.log(jqXHR);
      }
    });
  }
  resyncOrder() {
    if (!this.needsResync) {
      return;
    }
    if (!this.locationUid || this.locationUid === '') {
      this.locationUid = _freya_sync_service__WEBPACK_IMPORTED_MODULE_1__["default"].sharedInstance.settings.fsDefaultLocationUid;
    }
    const resyncButton = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('#fsResyncOrder');
    const resyncMessage = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('#fsResyncMessage');
    resyncButton.prop('disabled', true);
    resyncMessage.text('').addClass('hidden').removeClass('fss-notice-success').removeClass('fss-notice-error');
    _lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"].ajax({
      url: _freya_sync_service__WEBPACK_IMPORTED_MODULE_1__["default"].sharedInstance.data.ajax_url,
      dataType: 'json',
      type: 'POST',
      data: {
        action: 'fss_resync_order',
        order_id: this.orderId,
        location_uid: this.locationUid,
        nonce: _freya_sync_service__WEBPACK_IMPORTED_MODULE_1__["default"].sharedInstance.data.nonce
      },
      success: () => {
        resyncButton.prop('disabled', false);
        resyncMessage.addClass('fss-notice-success').removeClass('hidden').text('Comanda se va resincroniza în curând...');
      },
      error: jqXHR => {
        let message = 'Nu am putut sincroniza comanda din cauza unei erori interne!';
        if (jqXHR.status === 404) {
          message = 'Locația asociată comenzii nu mai există în sistemul Freya Sync sau este invalidă.';
        }
        resyncButton.prop('disabled', false);
        resyncMessage.text(message).addClass('fss-notice-error').removeClass('hidden');
      }
    });
  }
  setupJquery() {
    const id = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('#FS_ORDER_ID').attr('data-id');
    if (!id) {
      return;
    }
    this.orderId = Number(id);
    this.getOrder();
  }
}

/***/ }),

/***/ "./assets/src/scripts.ts":
/*!*******************************!*\
  !*** ./assets/src/scripts.ts ***!
  \*******************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _freya_sync_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./freya-sync-service */ "./assets/src/freya-sync-service.ts");



const data = {
  // @ts-ignore
  ajax_url: php_data.ajax_url,
  // @ts-ignore
  nonce: php_data.nonce,
  // @ts-ignore
  api_url: php_data.api_url,
  // @ts-ignore
  version: php_data.version,
  // @ts-ignore
  pickup: Boolean(php_data.pickup)
};
await _freya_sync_service__WEBPACK_IMPORTED_MODULE_0__["default"].bootstrap(data);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } }, 1);

/***/ }),

/***/ "./assets/src/settings-validator.ts":
/*!******************************************!*\
  !*** ./assets/src/settings-validator.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsValidator)
/* harmony export */ });
/* harmony import */ var _lib_jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lib/jquery */ "./assets/src/lib/jquery.ts");
/* harmony import */ var _freya_sync_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./freya-sync-service */ "./assets/src/freya-sync-service.ts");


class SettingsValidator {
  constructor() {
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('#fssTestConfiguration').on('click', async () => {
      await this.testConfiguration();
    });
  }
  updateResultLabel(status, message) {
    const verifyMessage = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('.fss-verify-message');
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('.fss-verify-message > p').text(message);
    if (status) {
      verifyMessage.addClass('notice-success').removeClass('notice-error');
    } else {
      verifyMessage.addClass('notice-error').removeClass('notice-success');
    }
    verifyMessage.removeClass('hide-popup');
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('#fssTestConfiguration').prop('disabled', false);
    jQuery('html, body').animate({
      scrollTop: 0
    }, 'fast');
  }
  async testConfiguration() {
    let apiUrl = _freya_sync_service__WEBPACK_IMPORTED_MODULE_1__["default"].sharedInstance.data.api_url;
    if (apiUrl.charAt(apiUrl.length - 1) !== '/') {
      apiUrl = apiUrl.concat('/');
    }
    const url = apiUrl + 'api/wp/verifyPluginConfig';
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('#fssTestConfiguration').prop('disabled', true);
    const settings = _freya_sync_service__WEBPACK_IMPORTED_MODULE_1__["default"].sharedInstance.settings;
    const data = {
      companyUid: settings.fsCompanyUid,
      defaultLocationUid: settings.fsDefaultLocationUid,
      hasPolygons: !settings.fsNoPolygons
    };
    const verifyMessage = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('.fss-verify-message');
    verifyMessage.removeClass('notice-error').removeClass('notice-success').addClass('hide-popup');
    const params = new URLSearchParams();
    params.set('companyUid', data.companyUid);
    params.set('defaultLocationUid', data.defaultLocationUid);
    params.set('hasPolygons', data.hasPolygons ? 'true' : 'false');
    return new Promise(async (resolve, reject) => {
      try {
        const r = await fetch(`${url}?${params.toString()}`, {
          method: 'GET',
          headers: {
            'content-type': 'application/json'
          }
        });
        const response = await r.json();
        if (!r.ok) {
          const message = this.getBadRequestMessage(r.status, response);
          this.updateResultLabel(false, message);
          return;
        }
        this.updateResultLabel(true, 'Setările s-au validat cu succes!');
      } catch (e) {
        this.updateResultLabel(false, 'URL-ul de API este incorect, sau serviciul Freya Sync nu este disponibil momentan.');
      }
    });
  }
  getBadRequestMessage(statusCode, response) {
    switch (statusCode) {
      case 400:
        return `${response.message}`;
      case 422:
        return this.getValidationErrorMessage(response);
      case 500:
      default:
        return 'Serviciul Freya Sync a întâmpinat o eroare internă!';
    }
  }
  static bootstrap() {
    if (this.instance) {
      return;
    }
    this.instance = new SettingsValidator();
  }
  static get sharedInstance() {
    if (!this.instance) {
      throw new Error('No SettingsValidator instance');
    }
    return this.instance;
  }
  mapFieldToName(field) {
    switch (field) {
      case 'companyUid':
        return "'UID Companie'";
      case 'defaultLocationUid':
        return "'UID Locație default'";
      case 'hasPolygons':
        return "'Compania nu are poligoane'";
      default:
        return field;
    }
  }
  getValidationErrorMessage(response) {
    var _a;
    const errors = (_a = response.payload.errors) !== null && _a !== void 0 ? _a : {};
    let fieldsWithError = '';
    const keys = Object.keys(errors);
    const count = keys.length;
    Object.keys(errors).forEach(key => {
      fieldsWithError += `${this.mapFieldToName(key)}, `;
    });
    fieldsWithError = fieldsWithError.slice(0, -2);
    if (count > 1) {
      return `Campurile ${fieldsWithError} nu sunt completate`;
    }
    return `Campul ${fieldsWithError} nu este completat`;
  }
}

/***/ }),

/***/ "./assets/src/topping-display.ts":
/*!***************************************!*\
  !*** ./assets/src/topping-display.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ToppingDisplay)
/* harmony export */ });
/* harmony import */ var _lib_jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lib/jquery */ "./assets/src/lib/jquery.ts");
/* harmony import */ var _freya_sync_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./freya-sync-service */ "./assets/src/freya-sync-service.ts");


class ToppingDisplay {
  constructor() {
    this.toppings = [];
    this.productPrice = 0;
    this.activeToppings = [];
    const id = (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('#FS_TOPPING_PARENT_ID').attr('data-id');
    if (!id) {
      return;
    }
    this.productId = Number(id);
    this.fetchToppings();
  }
  static bootstrap() {
    if (this.instance) {
      return;
    }
    this.instance = new ToppingDisplay();
  }
  static get sharedInstance() {
    if (!this.instance) {
      throw new Error('No ToppingDisplay shared instance');
    }
    return this.instance;
  }
  fetchToppings() {
    if (!this.productId) {
      return;
    }
    _lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"].ajax({
      url: _freya_sync_service__WEBPACK_IMPORTED_MODULE_1__["default"].sharedInstance.data.ajax_url,
      dataType: 'json',
      method: 'GET',
      data: {
        action: 'fss_get_toppings',
        id: this.productId,
        nonce: _freya_sync_service__WEBPACK_IMPORTED_MODULE_1__["default"].sharedInstance.data.nonce
      },
      success: res => {
        this.toppings = res.data.toppings;
        this.productPrice = Number(res.data.productPrice);
        this.toggleToppings();
      },
      error: jqXHR => {
        console.log(jqXHR.responseJSON);
      }
    });
  }
  toggleToppings() {
    if (this.toppings.length === 0) {
      return;
    }
    this.toppings.forEach(topping => {
      this.toggleToppingFromCheckbox(topping.freyaCode, false);
      (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])(`#checkbox-${topping.freyaCode}`).on('click', () => {
        this.toggleToppingFromCheckbox(topping.freyaCode, true);
      });
    });
    this.updateToppingPrice();
  }
  setToppingAsActive(freyaCode) {
    const topping = this.toppings.find(topping => topping.freyaCode === freyaCode);
    if (this.activeToppings.find(topping => topping.freyaCode === freyaCode)) {
      return;
    }
    if (topping) {
      this.activeToppings.push(topping);
    }
  }
  disableTopping(freyaCode) {
    this.activeToppings = this.activeToppings.filter(topping => topping.freyaCode !== freyaCode);
  }
  updateToppingPrice() {
    let price = this.productPrice;
    this.activeToppings.forEach(topping => {
      price += topping.price;
    });
    if (price === this.productPrice) {
      (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('#fsToppingTotal').addClass('fss-hide').text('');
    }
    (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])('#fsToppingTotal').text(`(${price.toLocaleString('ro-RO', {
      minimumFractionDigits: 2,
      maximumFractionDigits: 2
    })} lei cu topping-uri)`).removeClass('fss-hide');
  }
  toggleToppingFromCheckbox(freyaCode, priceUpdate) {
    if ((0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])(`#checkbox-${freyaCode}`).is(':checked')) {
      (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])(`#${freyaCode}`).removeClass('fss-hide');
      this.setToppingAsActive(freyaCode);
    } else {
      (0,_lib_jquery__WEBPACK_IMPORTED_MODULE_0__["default"])(`#${freyaCode}`).addClass('fss-hide');
      this.disableTopping(freyaCode);
    }
    if (priceUpdate) {
      this.updateToppingPrice();
    }
  }
}

/***/ }),

/***/ "./node_modules/devbridge-autocomplete/dist/jquery.autocomplete.js":
/*!*************************************************************************!*\
  !*** ./node_modules/devbridge-autocomplete/dist/jquery.autocomplete.js ***!
  \*************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/**
*  Ajax Autocomplete for jQuery, version 1.4.11
*  (c) 2017 Tomas Kirda
*
*  Ajax Autocomplete for jQuery is freely distributable under the terms of an MIT-style license.
*  For details, see the web site: https://github.com/devbridge/jQuery-Autocomplete
*/

/*jslint  browser: true, white: true, single: true, this: true, multivar: true */
/*global define, window, document, jQuery, exports, require */

// Expose plugin as an AMD module if AMD loader is present:
(function (factory) {
    "use strict";
    if (true) {
        // AMD. Register as an anonymous module.
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "jquery")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else {}
}(function ($) {
    'use strict';

    var
        utils = (function () {
            return {
                escapeRegExChars: function (value) {
                    return value.replace(/[|\\{}()[\]^$+*?.]/g, "\\$&");
                },
                createNode: function (containerClass) {
                    var div = document.createElement('div');
                    div.className = containerClass;
                    div.style.position = 'absolute';
                    div.style.display = 'none';
                    return div;
                }
            };
        }()),

        keys = {
            ESC: 27,
            TAB: 9,
            RETURN: 13,
            LEFT: 37,
            UP: 38,
            RIGHT: 39,
            DOWN: 40
        },

        noop = $.noop;

    function Autocomplete(el, options) {
        var that = this;

        // Shared variables:
        that.element = el;
        that.el = $(el);
        that.suggestions = [];
        that.badQueries = [];
        that.selectedIndex = -1;
        that.currentValue = that.element.value;
        that.timeoutId = null;
        that.cachedResponse = {};
        that.onChangeTimeout = null;
        that.onChange = null;
        that.isLocal = false;
        that.suggestionsContainer = null;
        that.noSuggestionsContainer = null;
        that.options = $.extend(true, {}, Autocomplete.defaults, options);
        that.classes = {
            selected: 'autocomplete-selected',
            suggestion: 'autocomplete-suggestion'
        };
        that.hint = null;
        that.hintValue = '';
        that.selection = null;

        // Initialize and set options:
        that.initialize();
        that.setOptions(options);
    }

    Autocomplete.utils = utils;

    $.Autocomplete = Autocomplete;

    Autocomplete.defaults = {
            ajaxSettings: {},
            autoSelectFirst: false,
            appendTo: 'body',
            serviceUrl: null,
            lookup: null,
            onSelect: null,
            width: 'auto',
            minChars: 1,
            maxHeight: 300,
            deferRequestBy: 0,
            params: {},
            formatResult: _formatResult,
            formatGroup: _formatGroup,
            delimiter: null,
            zIndex: 9999,
            type: 'GET',
            noCache: false,
            onSearchStart: noop,
            onSearchComplete: noop,
            onSearchError: noop,
            preserveInput: false,
            containerClass: 'autocomplete-suggestions',
            tabDisabled: false,
            dataType: 'text',
            currentRequest: null,
            triggerSelectOnValidInput: true,
            preventBadQueries: true,
            lookupFilter: _lookupFilter,
            paramName: 'query',
            transformResult: _transformResult,
            showNoSuggestionNotice: false,
            noSuggestionNotice: 'No results',
            orientation: 'bottom',
            forceFixPosition: false
    };

    function _lookupFilter(suggestion, originalQuery, queryLowerCase) {
        return suggestion.value.toLowerCase().indexOf(queryLowerCase) !== -1;
    };

    function _transformResult(response) {
        return typeof response === 'string' ? $.parseJSON(response) : response;
    };

    function _formatResult(suggestion, currentValue) {
        // Do not replace anything if the current value is empty
        if (!currentValue) {
            return suggestion.value;
        }

        var pattern = '(' + utils.escapeRegExChars(currentValue) + ')';

        return suggestion.value
            .replace(new RegExp(pattern, 'gi'), '<strong>$1<\/strong>')
            .replace(/&/g, '&amp;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;')
            .replace(/"/g, '&quot;')
            .replace(/&lt;(\/?strong)&gt;/g, '<$1>');
    };

    function _formatGroup(suggestion, category) {
        return '<div class="autocomplete-group">' + category + '</div>';
    };

    Autocomplete.prototype = {

        initialize: function () {
            var that = this,
                suggestionSelector = '.' + that.classes.suggestion,
                selected = that.classes.selected,
                options = that.options,
                container;

            that.element.setAttribute('autocomplete', 'off');

            // html() deals with many types: htmlString or Element or Array or jQuery
            that.noSuggestionsContainer = $('<div class="autocomplete-no-suggestion"></div>')
                                          .html(this.options.noSuggestionNotice).get(0);

            that.suggestionsContainer = Autocomplete.utils.createNode(options.containerClass);

            container = $(that.suggestionsContainer);

            container.appendTo(options.appendTo || 'body');

            // Only set width if it was provided:
            if (options.width !== 'auto') {
                container.css('width', options.width);
            }

            // Listen for mouse over event on suggestions list:
            container.on('mouseover.autocomplete', suggestionSelector, function () {
                that.activate($(this).data('index'));
            });

            // Deselect active element when mouse leaves suggestions container:
            container.on('mouseout.autocomplete', function () {
                that.selectedIndex = -1;
                container.children('.' + selected).removeClass(selected);
            });

            // Listen for click event on suggestions list:
            container.on('click.autocomplete', suggestionSelector, function () {
                that.select($(this).data('index'));
            });

            container.on('click.autocomplete', function () {
                clearTimeout(that.blurTimeoutId);
            })

            that.fixPositionCapture = function () {
                if (that.visible) {
                    that.fixPosition();
                }
            };

            $(window).on('resize.autocomplete', that.fixPositionCapture);

            that.el.on('keydown.autocomplete', function (e) { that.onKeyPress(e); });
            that.el.on('keyup.autocomplete', function (e) { that.onKeyUp(e); });
            that.el.on('blur.autocomplete', function () { that.onBlur(); });
            that.el.on('focus.autocomplete', function () { that.onFocus(); });
            that.el.on('change.autocomplete', function (e) { that.onKeyUp(e); });
            that.el.on('input.autocomplete', function (e) { that.onKeyUp(e); });
        },

        onFocus: function () {
            var that = this;

            if (that.disabled) {
                return;
            }

            that.fixPosition();

            if (that.el.val().length >= that.options.minChars) {
                that.onValueChange();
            }
        },

        onBlur: function () {
            var that = this,
                options = that.options,
                value = that.el.val(),
                query = that.getQuery(value);

            // If user clicked on a suggestion, hide() will
            // be canceled, otherwise close suggestions
            that.blurTimeoutId = setTimeout(function () {
                that.hide();

                if (that.selection && that.currentValue !== query) {
                    (options.onInvalidateSelection || $.noop).call(that.element);
                }
            }, 200);
        },

        abortAjax: function () {
            var that = this;
            if (that.currentRequest) {
                that.currentRequest.abort();
                that.currentRequest = null;
            }
        },

        setOptions: function (suppliedOptions) {
            var that = this,
                options = $.extend({}, that.options, suppliedOptions);

            that.isLocal = Array.isArray(options.lookup);

            if (that.isLocal) {
                options.lookup = that.verifySuggestionsFormat(options.lookup);
            }

            options.orientation = that.validateOrientation(options.orientation, 'bottom');

            // Adjust height, width and z-index:
            $(that.suggestionsContainer).css({
                'max-height': options.maxHeight + 'px',
                'width': options.width + 'px',
                'z-index': options.zIndex
            });

            this.options = options;
        },


        clearCache: function () {
            this.cachedResponse = {};
            this.badQueries = [];
        },

        clear: function () {
            this.clearCache();
            this.currentValue = '';
            this.suggestions = [];
        },

        disable: function () {
            var that = this;
            that.disabled = true;
            clearTimeout(that.onChangeTimeout);
            that.abortAjax();
        },

        enable: function () {
            this.disabled = false;
        },

        fixPosition: function () {
            // Use only when container has already its content

            var that = this,
                $container = $(that.suggestionsContainer),
                containerParent = $container.parent().get(0);
            // Fix position automatically when appended to body.
            // In other cases force parameter must be given.
            if (containerParent !== document.body && !that.options.forceFixPosition) {
                return;
            }

            // Choose orientation
            var orientation = that.options.orientation,
                containerHeight = $container.outerHeight(),
                height = that.el.outerHeight(),
                offset = that.el.offset(),
                styles = { 'top': offset.top, 'left': offset.left };

            if (orientation === 'auto') {
                var viewPortHeight = $(window).height(),
                    scrollTop = $(window).scrollTop(),
                    topOverflow = -scrollTop + offset.top - containerHeight,
                    bottomOverflow = scrollTop + viewPortHeight - (offset.top + height + containerHeight);

                orientation = (Math.max(topOverflow, bottomOverflow) === topOverflow) ? 'top' : 'bottom';
            }

            if (orientation === 'top') {
                styles.top += -containerHeight;
            } else {
                styles.top += height;
            }

            // If container is not positioned to body,
            // correct its position using offset parent offset
            if(containerParent !== document.body) {
                var opacity = $container.css('opacity'),
                    parentOffsetDiff;

                    if (!that.visible){
                        $container.css('opacity', 0).show();
                    }

                parentOffsetDiff = $container.offsetParent().offset();
                styles.top -= parentOffsetDiff.top;
                styles.top += containerParent.scrollTop;
                styles.left -= parentOffsetDiff.left;

                if (!that.visible){
                    $container.css('opacity', opacity).hide();
                }
            }

            if (that.options.width === 'auto') {
                styles.width = that.el.outerWidth() + 'px';
            }

            $container.css(styles);
        },

        isCursorAtEnd: function () {
            var that = this,
                valLength = that.el.val().length,
                selectionStart = that.element.selectionStart,
                range;

            if (typeof selectionStart === 'number') {
                return selectionStart === valLength;
            }
            if (document.selection) {
                range = document.selection.createRange();
                range.moveStart('character', -valLength);
                return valLength === range.text.length;
            }
            return true;
        },

        onKeyPress: function (e) {
            var that = this;

            // If suggestions are hidden and user presses arrow down, display suggestions:
            if (!that.disabled && !that.visible && e.which === keys.DOWN && that.currentValue) {
                that.suggest();
                return;
            }

            if (that.disabled || !that.visible) {
                return;
            }

            switch (e.which) {
                case keys.ESC:
                    that.el.val(that.currentValue);
                    that.hide();
                    break;
                case keys.RIGHT:
                    if (that.hint && that.options.onHint && that.isCursorAtEnd()) {
                        that.selectHint();
                        break;
                    }
                    return;
                case keys.TAB:
                    if (that.hint && that.options.onHint) {
                        that.selectHint();
                        return;
                    }
                    if (that.selectedIndex === -1) {
                        that.hide();
                        return;
                    }
                    that.select(that.selectedIndex);
                    if (that.options.tabDisabled === false) {
                        return;
                    }
                    break;
                case keys.RETURN:
                    if (that.selectedIndex === -1) {
                        that.hide();
                        return;
                    }
                    that.select(that.selectedIndex);
                    break;
                case keys.UP:
                    that.moveUp();
                    break;
                case keys.DOWN:
                    that.moveDown();
                    break;
                default:
                    return;
            }

            // Cancel event if function did not return:
            e.stopImmediatePropagation();
            e.preventDefault();
        },

        onKeyUp: function (e) {
            var that = this;

            if (that.disabled) {
                return;
            }

            switch (e.which) {
                case keys.UP:
                case keys.DOWN:
                    return;
            }

            clearTimeout(that.onChangeTimeout);

            if (that.currentValue !== that.el.val()) {
                that.findBestHint();
                if (that.options.deferRequestBy > 0) {
                    // Defer lookup in case when value changes very quickly:
                    that.onChangeTimeout = setTimeout(function () {
                        that.onValueChange();
                    }, that.options.deferRequestBy);
                } else {
                    that.onValueChange();
                }
            }
        },

        onValueChange: function () {
            if (this.ignoreValueChange) {
                this.ignoreValueChange = false;
                return;
            }

            var that = this,
                options = that.options,
                value = that.el.val(),
                query = that.getQuery(value);

            if (that.selection && that.currentValue !== query) {
                that.selection = null;
                (options.onInvalidateSelection || $.noop).call(that.element);
            }

            clearTimeout(that.onChangeTimeout);
            that.currentValue = value;
            that.selectedIndex = -1;

            // Check existing suggestion for the match before proceeding:
            if (options.triggerSelectOnValidInput && that.isExactMatch(query)) {
                that.select(0);
                return;
            }

            if (query.length < options.minChars) {
                that.hide();
            } else {
                that.getSuggestions(query);
            }
        },

        isExactMatch: function (query) {
            var suggestions = this.suggestions;

            return (suggestions.length === 1 && suggestions[0].value.toLowerCase() === query.toLowerCase());
        },

        getQuery: function (value) {
            var delimiter = this.options.delimiter,
                parts;

            if (!delimiter) {
                return value;
            }
            parts = value.split(delimiter);
            return $.trim(parts[parts.length - 1]);
        },

        getSuggestionsLocal: function (query) {
            var that = this,
                options = that.options,
                queryLowerCase = query.toLowerCase(),
                filter = options.lookupFilter,
                limit = parseInt(options.lookupLimit, 10),
                data;

            data = {
                suggestions: $.grep(options.lookup, function (suggestion) {
                    return filter(suggestion, query, queryLowerCase);
                })
            };

            if (limit && data.suggestions.length > limit) {
                data.suggestions = data.suggestions.slice(0, limit);
            }

            return data;
        },

        getSuggestions: function (q) {
            var response,
                that = this,
                options = that.options,
                serviceUrl = options.serviceUrl,
                params,
                cacheKey,
                ajaxSettings;

            options.params[options.paramName] = q;

            if (options.onSearchStart.call(that.element, options.params) === false) {
                return;
            }

            params = options.ignoreParams ? null : options.params;

            if ($.isFunction(options.lookup)){
                options.lookup(q, function (data) {
                    that.suggestions = data.suggestions;
                    that.suggest();
                    options.onSearchComplete.call(that.element, q, data.suggestions);
                });
                return;
            }

            if (that.isLocal) {
                response = that.getSuggestionsLocal(q);
            } else {
                if ($.isFunction(serviceUrl)) {
                    serviceUrl = serviceUrl.call(that.element, q);
                }
                cacheKey = serviceUrl + '?' + $.param(params || {});
                response = that.cachedResponse[cacheKey];
            }

            if (response && Array.isArray(response.suggestions)) {
                that.suggestions = response.suggestions;
                that.suggest();
                options.onSearchComplete.call(that.element, q, response.suggestions);
            } else if (!that.isBadQuery(q)) {
                that.abortAjax();

                ajaxSettings = {
                    url: serviceUrl,
                    data: params,
                    type: options.type,
                    dataType: options.dataType
                };

                $.extend(ajaxSettings, options.ajaxSettings);

                that.currentRequest = $.ajax(ajaxSettings).done(function (data) {
                    var result;
                    that.currentRequest = null;
                    result = options.transformResult(data, q);
                    that.processResponse(result, q, cacheKey);
                    options.onSearchComplete.call(that.element, q, result.suggestions);
                }).fail(function (jqXHR, textStatus, errorThrown) {
                    options.onSearchError.call(that.element, q, jqXHR, textStatus, errorThrown);
                });
            } else {
                options.onSearchComplete.call(that.element, q, []);
            }
        },

        isBadQuery: function (q) {
            if (!this.options.preventBadQueries){
                return false;
            }

            var badQueries = this.badQueries,
                i = badQueries.length;

            while (i--) {
                if (q.indexOf(badQueries[i]) === 0) {
                    return true;
                }
            }

            return false;
        },

        hide: function () {
            var that = this,
                container = $(that.suggestionsContainer);

            if ($.isFunction(that.options.onHide) && that.visible) {
                that.options.onHide.call(that.element, container);
            }

            that.visible = false;
            that.selectedIndex = -1;
            clearTimeout(that.onChangeTimeout);
            $(that.suggestionsContainer).hide();
            that.signalHint(null);
        },

        suggest: function () {
            if (!this.suggestions.length) {
                if (this.options.showNoSuggestionNotice) {
                    this.noSuggestions();
                } else {
                    this.hide();
                }
                return;
            }

            var that = this,
                options = that.options,
                groupBy = options.groupBy,
                formatResult = options.formatResult,
                value = that.getQuery(that.currentValue),
                className = that.classes.suggestion,
                classSelected = that.classes.selected,
                container = $(that.suggestionsContainer),
                noSuggestionsContainer = $(that.noSuggestionsContainer),
                beforeRender = options.beforeRender,
                html = '',
                category,
                formatGroup = function (suggestion, index) {
                        var currentCategory = suggestion.data[groupBy];

                        if (category === currentCategory){
                            return '';
                        }

                        category = currentCategory;

                        return options.formatGroup(suggestion, category);
                    };

            if (options.triggerSelectOnValidInput && that.isExactMatch(value)) {
                that.select(0);
                return;
            }

            // Build suggestions inner HTML:
            $.each(that.suggestions, function (i, suggestion) {
                if (groupBy){
                    html += formatGroup(suggestion, value, i);
                }

                html += '<div class="' + className + '" data-index="' + i + '">' + formatResult(suggestion, value, i) + '</div>';
            });

            this.adjustContainerWidth();

            noSuggestionsContainer.detach();
            container.html(html);

            if ($.isFunction(beforeRender)) {
                beforeRender.call(that.element, container, that.suggestions);
            }

            that.fixPosition();
            container.show();

            // Select first value by default:
            if (options.autoSelectFirst) {
                that.selectedIndex = 0;
                container.scrollTop(0);
                container.children('.' + className).first().addClass(classSelected);
            }

            that.visible = true;
            that.findBestHint();
        },

        noSuggestions: function() {
             var that = this,
                 beforeRender = that.options.beforeRender,
                 container = $(that.suggestionsContainer),
                 noSuggestionsContainer = $(that.noSuggestionsContainer);

            this.adjustContainerWidth();

            // Some explicit steps. Be careful here as it easy to get
            // noSuggestionsContainer removed from DOM if not detached properly.
            noSuggestionsContainer.detach();

            // clean suggestions if any
            container.empty();
            container.append(noSuggestionsContainer);

            if ($.isFunction(beforeRender)) {
                beforeRender.call(that.element, container, that.suggestions);
            }

            that.fixPosition();

            container.show();
            that.visible = true;
        },

        adjustContainerWidth: function() {
            var that = this,
                options = that.options,
                width,
                container = $(that.suggestionsContainer);

            // If width is auto, adjust width before displaying suggestions,
            // because if instance was created before input had width, it will be zero.
            // Also it adjusts if input width has changed.
            if (options.width === 'auto') {
                width = that.el.outerWidth();
                container.css('width', width > 0 ? width : 300);
            } else if(options.width === 'flex') {
                // Trust the source! Unset the width property so it will be the max length
                // the containing elements.
                container.css('width', '');
            }
        },

        findBestHint: function () {
            var that = this,
                value = that.el.val().toLowerCase(),
                bestMatch = null;

            if (!value) {
                return;
            }

            $.each(that.suggestions, function (i, suggestion) {
                var foundMatch = suggestion.value.toLowerCase().indexOf(value) === 0;
                if (foundMatch) {
                    bestMatch = suggestion;
                }
                return !foundMatch;
            });

            that.signalHint(bestMatch);
        },

        signalHint: function (suggestion) {
            var hintValue = '',
                that = this;
            if (suggestion) {
                hintValue = that.currentValue + suggestion.value.substr(that.currentValue.length);
            }
            if (that.hintValue !== hintValue) {
                that.hintValue = hintValue;
                that.hint = suggestion;
                (this.options.onHint || $.noop)(hintValue);
            }
        },

        verifySuggestionsFormat: function (suggestions) {
            // If suggestions is string array, convert them to supported format:
            if (suggestions.length && typeof suggestions[0] === 'string') {
                return $.map(suggestions, function (value) {
                    return { value: value, data: null };
                });
            }

            return suggestions;
        },

        validateOrientation: function(orientation, fallback) {
            orientation = $.trim(orientation || '').toLowerCase();

            if($.inArray(orientation, ['auto', 'bottom', 'top']) === -1){
                orientation = fallback;
            }

            return orientation;
        },

        processResponse: function (result, originalQuery, cacheKey) {
            var that = this,
                options = that.options;

            result.suggestions = that.verifySuggestionsFormat(result.suggestions);

            // Cache results if cache is not disabled:
            if (!options.noCache) {
                that.cachedResponse[cacheKey] = result;
                if (options.preventBadQueries && !result.suggestions.length) {
                    that.badQueries.push(originalQuery);
                }
            }

            // Return if originalQuery is not matching current query:
            if (originalQuery !== that.getQuery(that.currentValue)) {
                return;
            }

            that.suggestions = result.suggestions;
            that.suggest();
        },

        activate: function (index) {
            var that = this,
                activeItem,
                selected = that.classes.selected,
                container = $(that.suggestionsContainer),
                children = container.find('.' + that.classes.suggestion);

            container.find('.' + selected).removeClass(selected);

            that.selectedIndex = index;

            if (that.selectedIndex !== -1 && children.length > that.selectedIndex) {
                activeItem = children.get(that.selectedIndex);
                $(activeItem).addClass(selected);
                return activeItem;
            }

            return null;
        },

        selectHint: function () {
            var that = this,
                i = $.inArray(that.hint, that.suggestions);

            that.select(i);
        },

        select: function (i) {
            var that = this;
            that.hide();
            that.onSelect(i);
        },

        moveUp: function () {
            var that = this;

            if (that.selectedIndex === -1) {
                return;
            }

            if (that.selectedIndex === 0) {
                $(that.suggestionsContainer).children('.' + that.classes.suggestion).first().removeClass(that.classes.selected);
                that.selectedIndex = -1;
                that.ignoreValueChange = false;
                that.el.val(that.currentValue);
                that.findBestHint();
                return;
            }

            that.adjustScroll(that.selectedIndex - 1);
        },

        moveDown: function () {
            var that = this;

            if (that.selectedIndex === (that.suggestions.length - 1)) {
                return;
            }

            that.adjustScroll(that.selectedIndex + 1);
        },

        adjustScroll: function (index) {
            var that = this,
                activeItem = that.activate(index);

            if (!activeItem) {
                return;
            }

            var offsetTop,
                upperBound,
                lowerBound,
                heightDelta = $(activeItem).outerHeight();

            offsetTop = activeItem.offsetTop;
            upperBound = $(that.suggestionsContainer).scrollTop();
            lowerBound = upperBound + that.options.maxHeight - heightDelta;

            if (offsetTop < upperBound) {
                $(that.suggestionsContainer).scrollTop(offsetTop);
            } else if (offsetTop > lowerBound) {
                $(that.suggestionsContainer).scrollTop(offsetTop - that.options.maxHeight + heightDelta);
            }

            if (!that.options.preserveInput) {
                // During onBlur event, browser will trigger "change" event,
                // because value has changed, to avoid side effect ignore,
                // that event, so that correct suggestion can be selected
                // when clicking on suggestion with a mouse
                that.ignoreValueChange = true;
                that.el.val(that.getValue(that.suggestions[index].value));
            }

            that.signalHint(null);
        },

        onSelect: function (index) {
            var that = this,
                onSelectCallback = that.options.onSelect,
                suggestion = that.suggestions[index];

            that.currentValue = that.getValue(suggestion.value);

            if (that.currentValue !== that.el.val() && !that.options.preserveInput) {
                that.el.val(that.currentValue);
            }

            that.signalHint(null);
            that.suggestions = [];
            that.selection = suggestion;

            if ($.isFunction(onSelectCallback)) {
                onSelectCallback.call(that.element, suggestion);
            }
        },

        getValue: function (value) {
            var that = this,
                delimiter = that.options.delimiter,
                currentValue,
                parts;

            if (!delimiter) {
                return value;
            }

            currentValue = that.currentValue;
            parts = currentValue.split(delimiter);

            if (parts.length === 1) {
                return value;
            }

            return currentValue.substr(0, currentValue.length - parts[parts.length - 1].length) + value;
        },

        dispose: function () {
            var that = this;
            that.el.off('.autocomplete').removeData('autocomplete');
            $(window).off('resize.autocomplete', that.fixPositionCapture);
            $(that.suggestionsContainer).remove();
        }
    };

    // Create chainable jQuery plugin:
    $.fn.devbridgeAutocomplete = function (options, args) {
        var dataKey = 'autocomplete';
        // If function invoked without argument return
        // instance of the first matched element:
        if (!arguments.length) {
            return this.first().data(dataKey);
        }

        return this.each(function () {
            var inputElement = $(this),
                instance = inputElement.data(dataKey);

            if (typeof options === 'string') {
                if (instance && typeof instance[options] === 'function') {
                    instance[options](args);
                }
            } else {
                // If instance already exists, destroy it:
                if (instance && instance.dispose) {
                    instance.dispose();
                }
                instance = new Autocomplete(this, options);
                inputElement.data(dataKey, instance);
            }
        });
    };

    // Don't overwrite if it already exists
    if (!$.fn.autocomplete) {
        $.fn.autocomplete = $.fn.devbridgeAutocomplete;
    }
}));


/***/ }),

/***/ "jquery":
/*!*************************!*\
  !*** external "jQuery" ***!
  \*************************/
/***/ ((module) => {

"use strict";
module.exports = window["jQuery"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/async module */
/******/ 	(() => {
/******/ 		var webpackQueues = typeof Symbol === "function" ? Symbol("webpack queues") : "__webpack_queues__";
/******/ 		var webpackExports = typeof Symbol === "function" ? Symbol("webpack exports") : "__webpack_exports__";
/******/ 		var webpackError = typeof Symbol === "function" ? Symbol("webpack error") : "__webpack_error__";
/******/ 		var resolveQueue = (queue) => {
/******/ 			if(queue && queue.d < 1) {
/******/ 				queue.d = 1;
/******/ 				queue.forEach((fn) => (fn.r--));
/******/ 				queue.forEach((fn) => (fn.r-- ? fn.r++ : fn()));
/******/ 			}
/******/ 		}
/******/ 		var wrapDeps = (deps) => (deps.map((dep) => {
/******/ 			if(dep !== null && typeof dep === "object") {
/******/ 				if(dep[webpackQueues]) return dep;
/******/ 				if(dep.then) {
/******/ 					var queue = [];
/******/ 					queue.d = 0;
/******/ 					dep.then((r) => {
/******/ 						obj[webpackExports] = r;
/******/ 						resolveQueue(queue);
/******/ 					}, (e) => {
/******/ 						obj[webpackError] = e;
/******/ 						resolveQueue(queue);
/******/ 					});
/******/ 					var obj = {};
/******/ 					obj[webpackQueues] = (fn) => (fn(queue));
/******/ 					return obj;
/******/ 				}
/******/ 			}
/******/ 			var ret = {};
/******/ 			ret[webpackQueues] = x => {};
/******/ 			ret[webpackExports] = dep;
/******/ 			return ret;
/******/ 		}));
/******/ 		__webpack_require__.a = (module, body, hasAwait) => {
/******/ 			var queue;
/******/ 			hasAwait && ((queue = []).d = -1);
/******/ 			var depQueues = new Set();
/******/ 			var exports = module.exports;
/******/ 			var currentDeps;
/******/ 			var outerResolve;
/******/ 			var reject;
/******/ 			var promise = new Promise((resolve, rej) => {
/******/ 				reject = rej;
/******/ 				outerResolve = resolve;
/******/ 			});
/******/ 			promise[webpackExports] = exports;
/******/ 			promise[webpackQueues] = (fn) => (queue && fn(queue), depQueues.forEach(fn), promise["catch"](x => {}));
/******/ 			module.exports = promise;
/******/ 			body((deps) => {
/******/ 				currentDeps = wrapDeps(deps);
/******/ 				var fn;
/******/ 				var getResult = () => (currentDeps.map((d) => {
/******/ 					if(d[webpackError]) throw d[webpackError];
/******/ 					return d[webpackExports];
/******/ 				}))
/******/ 				var promise = new Promise((resolve) => {
/******/ 					fn = () => (resolve(getResult));
/******/ 					fn.r = 0;
/******/ 					var fnQueue = (q) => (q !== queue && !depQueues.has(q) && (depQueues.add(q), q && !q.d && (fn.r++, q.push(fn))));
/******/ 					currentDeps.map((dep) => (dep[webpackQueues](fnQueue)));
/******/ 				});
/******/ 				return fn.r ? promise : getResult();
/******/ 			}, (err) => ((err ? reject(promise[webpackError] = err) : outerResolve(exports)), resolveQueue(queue)));
/******/ 			queue && queue.d < 0 && (queue.d = 0);
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module used 'module' so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./assets/src/scripts.ts");
/******/ 	
/******/ })()
;
//# sourceMappingURL=scripts.js.map