<?php
  /** @var bool $hasPickup */
  /** @var bool $hasDelivery */
  /** @var bool $pickup */
  /** @var bool $hasFA */
  /** @var \Soft_Tehnica\Freya_Sync_Service\Data\Location[] $locations */
  /** @var ?string $activeLocationUid */
  /** @var ?string $userAddress */
?>

<div class="fss-modal" id="fss-modal">
  <div class="fss-modal__container">
    <h1 class="fss-modal__title">Preferințe livrare</h1>
    <h2 class="fss-modal__subtitle">Pentru a putea alege locația care vă va
      servi, vă rugăm să vă alegeți preferințele
      de livrare</h2>
    <?php if($hasPickup === true && $hasDelivery === true): ?>
      <section class="fss-delivery-choice-container">
        <fieldset class="fss-delivery-choice">
          <legend>Selectați o metodă de livrare</legend>
          <div>
            <input type="radio" name="deliveryType" id="fssDelivery" value="1"
              <?php if($pickup === false): ?> checked="checked" <?php endif; ?>>
            <label for="fssDelivery">Livrare</label>
          </div>
          <div>
            <input type="radio" name="deliveryType" id="fssPickup" value="2"
              <?php if($pickup): ?> checked="checked" <?php endif; ?>>
            <label for="fssPickup">Ridicare personală</label>
          </div>
        </fieldset>
        <div class="fss-delivery-choice"></div>
      </section>
    <?php endif; ?>
    <div class="fss-modal__body">
      <form class="fss-user-address-form">
        <?php if($hasDelivery): ?>
          <div class="fss-modal__fields_group">
            <div class="fss-form-item-container flex-long">
              <label for="streetName">Stradă și număr</label>
              <input type="text" id="streetName" name="streetName" class="streetName" autocomplete="off">
            </div>
            <div class="fss-form-item-container">
              <label for="streetNo">Număr stradă</label>
              <input type="text" id="streetNo" name="streetNo" class="streetNo">
            </div>
            <div class="fss-form-item-container">
              <label for="blockNo">Bloc</label>
              <input type="text" id="blockNo" name="blockNo" class="blockNo">
            </div>
            <div class="fss-form-item-container">
              <label for="entranceNo">Scară</label>
              <input type="text" id="entranceNo" name="entranceNo" class="entranceNo">
            </div>
            <div class="fss-form-item-container">
              <label for="floor">Etaj</label>
              <input type="text" id="floor" name="floor" class="fss-floor">
            </div>
            <div class="fss-form-item-container">
              <label for="apartmentNo">Apartament</label>
              <input type="text" id="apartmentNo" name="apartmentNo" class="apartmentNo">
            </div>
          </div>
        <?php endif; ?>
        <?php if($hasPickup): ?>
          <div class="location-select-container">
            <label for="location">Alegeți locația de la care
              ridicați
              comanda</label>
            <select id="location" name="location">
              <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($location->hasPickup): ?>
                  <?php
                    $selected = $activeLocationUid !== null && $activeLocationUid === $location->uid;
                  ?>
                  <option value="<?php echo e($location->uid); ?>" <?php if($selected): ?> selected <?php endif; ?>>
                    <?php echo e($location->name); ?></option>
                <?php endif; ?>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
        <?php endif; ?>
      </form>
      <?php if($noAddressMessage): ?>
        <p class="fss-modal__subtitle noAddressFoundMessage"><?php echo e($noAddressMessage); ?></p>
      <?php endif; ?>

      <?php if(isset($userAddress) && strlen($userAddress) > 0): ?>
        <p class="fss-modal__subtitle">Adresa dumeavoastră curentă
          este: <?php echo e($userAddress); ?></p>
      <?php endif; ?>
      <p class="fss-modal__subtitle">Schimband adresa, este
        posibil să
        se șteargă și coșul de cumpărături în
        funcție
        de locația din care se va face livrarea.</p>
      <p id='localizationModalErrorMessages'></p>
      <p id='localizationModalSuccessMessages'></p>

      <div class="fss-modal__buttons">
        <?php if(!$hideDismiss): ?>
          <button class="btn-secondary address-modal-close">
            <?php if($hasFA): ?>
              <i class="fa fa-spinner fa-spin cancelLoading"></i>
            <?php endif; ?>
            Anulează
          </button>
        <?php endif; ?>
        <button class="btn-primary address-modal-save">
          <?php if($hasFA): ?>
            <i class="fa fa-spinner fa-spin mLoading"></i>
          <?php endif; ?>
          Salvează
        </button>
      </div>
    </div>
  </div>
</div>
<?php /**PATH /var/www/html/wp-content/plugins/freya-sync-service/views/modal-address.blade.php ENDPATH**/ ?>